varying vec2 f_texcoord;
#ifdef LIGHTING
varying vec4 f_colorLightAmbient, f_colorLightDiffuse;
#endif

uniform sampler2D texture;

#ifdef HIGHLIGHT
uniform vec4 highlight;
#endif

#ifdef LIGHTING
	#ifdef SPECULAR
	varying vec4 f_colorLightSpecular;
		#ifdef SPECULAR_MAP
		uniform sampler2D texture_specular;
		#endif
	#endif

	#ifdef SHADOW
		uniform int shadow_csm_index;
		uniform sampler2DShadow texture_shadow_close;
		uniform sampler2DShadow texture_shadow_far;
		varying vec4 f_shadow_coord;

		#ifndef SHADOW_MAP_CORRESPONDS_SUBDIVS
		varying vec4 f_shadow_coord_far;
		varying vec3 coord_world;
		uniform vec3 shadow_close_center;
		#endif

		#ifdef SHADOW_SLOPE_BIAS
		varying float f_shadow_slope_bias;
		#endif
	#endif
#endif

#ifdef FOG
varying float f_fogFactor;
varying float f_fogFactorGround;
#endif



void main(void)
{
	vec2 texcoord = f_texcoord;
#ifdef BACKFACE_FLIP
	if(!gl_FrontFacing)
	{
		const float range = 0.202; //use uniform once necessary
		const float range2 = 0.191;
		const float rangeInv = 1.0/range;

		float uLeft = range * floor(texcoord.x*rangeInv);
		float uOff = texcoord.x - uLeft;
		texcoord.x = uLeft + range2 - uOff;
	}
#endif

	vec4 colorResult = texture2D(texture, texcoord);

#ifdef ALPHA_TEST
	doAlphaTest(colorResult.w);
#endif

#ifdef HIGHLIGHT
	colorResult = mix(colorResult, vec4(highlight.xyz, colorResult.a), highlight.w);
#endif

#ifdef LIGHTING
		vec4 colorLightNonAmbient = f_colorLightDiffuse;
	#ifdef SPECULAR
		vec4 colorSpecular = f_colorLightSpecular;
		#ifdef SPECULAR_MAP
		colorSpecular *= texture2D(texture_specular, texcoord);
		#endif
		colorLightNonAmbient += colorSpecular;
	#endif

	#ifdef SHADOW
		#ifdef SHADOW_SLOPE_BIAS
		float shadow_slope_bias = f_shadow_slope_bias;
		#else
		float shadow_slope_bias = SHADOW_SLOPE_BIAS_CONST;
		#endif

		#ifndef SHADOW_MAP_CORRESPONDS_SUBDIVS
		float visibility = getVisibility(shadow_csm_index, texture_shadow_close, texture_shadow_far, f_shadow_coord, f_shadow_coord_far, shadow_slope_bias, shadow_close_center, coord_world);
		#else
		float visibility = getVisibility(shadow_csm_index, texture_shadow_close, texture_shadow_far, f_shadow_coord, shadow_slope_bias);
		#endif

		colorLightNonAmbient = getVisibilityVector(visibility) * colorLightNonAmbient;
	#endif

	colorResult = (colorLightNonAmbient + f_colorLightAmbient) * colorResult;
#endif

#ifdef FOG
	colorResult.rgb = mix(colorResult.rgb, FOG_COLOR, f_fogFactor);
	colorResult.rgb = mix(colorResult.rgb, FOG_COLOR_GROUND, f_fogFactorGround);
#endif

	gl_FragColor = colorResult;
}

